'MMEDIT!!! Basic Version = Micromite_MK2_V5.3
'MMEDIT!!! Port = 192.168.59.185:23:30,150
'MMEDIT!!! Device = Micromite_MK2_V5.3
'MMEDIT!!! Config = 100111100121010110000000000001
  'Volts                  00 00  'Frequency              00 46
  'Current                00 06  'Import active energy   00 48
  'Active power           00 0C  'Export active energy   00 4A
  'Apparent power         00 12  'Import reactive energy 00 4C
  'Reactive power         00 18  'Export reactive energy 00 4E
  'Power factor           00 1E  'Total active energy    01 56
  'Phase angle            00 24  'Total reactive energy  01 58
  Option Explicit
  Option Autorun On
  
  Dim Integer Addr%,DevAdr%,Fcode%=04,SAdH%,SAdL%,NBtH%,NBtL%   'Variables used to build request String
  Dim Integer ReqType=1,ReqNum,NumDev=3
  Dim Integer TimerRc=Timer,k=1000
  
  Dim Float Volts(4),Amps(4),Watts(4),VAs(4),VAsR(4),PF(4)
  Dim Float TotImp(4),TotExp(4)
  
  Dim String DataStr,ReqStr,Response$
  Dim String Esc=Chr$(27)
  
  Open "Com1:9600,,RecComs,8" As #1
  
  CLS
  Print Esc+"[f";Esc+"[J";
  
  Do
    
    ReqData
    UpdateLCD
    UpdateConsole
    
    Pause 500
    
  Loop
  
Sub ReqData1
  
    ReqNum=ReqNum+1
  
  If ReqNum>NumDev+117 Then
    ReqNum=1
    Addr%=0
    ReqType=1
  End If
  
  If Addr%<NumDev Then Addr%=Addr%+1 Else Addr%=1
  If ReqNum>NumDev Then ReqType=0
  
  If ReqType=0 Then
    SAdL%=&h00 : NBtL%=&h20
  Else If ReqType=1 Then
    SAdL%=&h48 : NBtL%=&h04
  End If
  
  ReqStr=BldReq(Addr%,FCode%,SAdH%,SAdL%,NBtH%,NBtL%)
  Print #1, ReqStr;
  
End Sub

Sub ReqData
  
    ReqNum=ReqNum+1
  
  If ReqNum>10 Then
    ReqNum=1
    'Addr%=0
    ReqType=1
  End If
  
  'If Addr%<NumDev Then Addr%=Addr%+1 Else Addr%=1
  If ReqNum>1 Then ReqType=0
  
  If ReqType=0 Then
    SAdL%=&h00 : NBtL%=&h20
  Else If ReqType=1 Then
    SAdL%=&h48 : NBtL%=&h04
  End If
  
  For Addr%=1 to NumDev
  ReqStr=BldReq(Addr%,FCode%,SAdH%,SAdL%,NBtH%,NBtL%)
  Print #1, ReqStr;
  Pause 20
  Next Addr%
End Sub
  
Function BldReq(Ad%,Fc%,A1%,A2%,N1%,N2%) As String
  BldReq=Chr$(Ad%)+Chr$(Fc%)+Chr$(A1%)+Chr$(A2%)+Chr$(N1%)+Chr$(N2%)
  BldReq=BldReq+CrcStr(BldReq)
End Function
  
Sub RecComs
  
  Local Integer BufLen,BytCnt%,n
  TimerRc=Timer
  
  Do While BufLen<> Loc(#1)
    BufLen=Loc(#1)
    Pause 5                   'Wait 5mS to see in the Buffer Grows
  Loop
  
  DataStr=Input$(Loc(#1),#1) 'Read everything in the buffer.
  Response$=""
  
  For n=1 To Len(DataStr)
    Response$=Response$+Hex$(Asc(Mid$(DataStr,n,1)),2)
  Next n
  
  DevAdr%=Val("&h"+Left$(Response$,2))
  BytCnt%=Val("&h"+Mid$(Response$,5,2))
  
  Select Case BytCnt%
      
    Case 8
      TotImp(DevAdr%)=Bin2Flt(Mid$(Response$, 7,8))
      TotExp(DevAdr%)=Bin2Flt(Mid$(Response$, 15,8))
      
    Case 64
      Volts(DevAdr%)=Bin2Flt(Mid$(Response$, 7,8))
      Amps(DevAdr%)=Bin2Flt(Mid$(Response$, 31,8))
      Watts(DevAdr%)=Bin2Flt(Mid$(Response$, 55,8))
      VAs(DevAdr%)=Bin2Flt(Mid$(Response$, 79,8))
      VAsR(DevAdr%)=Bin2Flt(Mid$(Response$, 103,8))
      PF(DevAdr%)=Bin2Flt(Mid$(Response$, 127,8))
      Watts(4)=Watts(3)-Watts(2)
      VAs(4)=VAs(3)-VAs(2)
      
  End Select
  
  TimerRc=Timer-TimerRc
  
End Sub
  
Function CrcStr(a$) As String
  
  Local ErrorWord% = &HFFFF, n, j, ByteVal, LSB
  Local CrcHex As Integer
  For n = 1 To Len(A$)
    ByteVal = Asc(Mid$(a$, n, 1))
    ErrorWord% = (ErrorWord% And &HFFFF) Xor Asc(Mid$(a$, n, 1))
    For j = 1 To 8
      LSB = ErrorWord% And &H0001
      If LSB = 1 Then ErrorWord% = ErrorWord% - 1
      ErrorWord% = ErrorWord% / 2
      If LSB = 1 Then ErrorWord% = ErrorWord% Xor &HA001
    Next j
  Next n
  CrcHex = ErrorWord% And &HFFFF
  CrcStr=Chr$(CrcHex And &hFF)+Chr$(CrcHex>>8)
  
End Function
  
  
Function Bin2Flt(IeeeStr As String) As Float
  Local Integer Reading%,Sign%,Expo%
  Local Float x,y,z
  IeeeStr="&h"+IeeeStr
  Reading%=Val(IeeeStr)
  Sign%=Reading% >> 31                                                'Read the Sign Bit
  Expo%=((Reading% >> 23) And &hff) - 127                             'Extract Exponent, Remove sign, Subtract Offset
  
  'Ans!=((Reading% Or &h800000) And &hffffff)/2^(23-Expo%)*(-1)^Sign%  'Extract Mantissa & Add implied 24th bit, Shift Point in Binary & apply sign
  x! = 2^(23-Expo%)
  y! = (-1)^Sign%
  z! = ((Reading% Or &h800000) And &hffffff)
  '    print x!, y!, z!
  If x!*y!<>0 Then Bin2Flt=z!/x!*y! Else Bin2Flt=0
  
End Function
  
  
  '==========================Update LCD Display=================================
Sub UpdateLCD
  
  Text MM.HRes/40, MM.VRes*1/10, "Volts", LB, 2, 1, RGB(Green)
  Text MM.HRes/40, MM.VRes*2/10, "Amps ", LB, 2, 1, RGB(Cyan)
  Text MM.HRes/40, MM.VRes*3/10, "kW   ", LB, 2, 1, RGB(Red)
  Text MM.HRes/40, MM.VRes*4/10, "kVA  ", LB, 2, 1, RGB(Blue)
  Text MM.HRes/40, MM.VRes*5/10, "kVAr ", LB, 2, 1, RGB(Cyan)
  Text MM.HRes/40, MM.VRes*6/10, "PF   ", LB, 2, 1, RGB(Magenta)
  Text MM.HRes/40, MM.VRes*7/10, "Solar", LB, 2, 1, RGB(Yellow)
  Text MM.HRes/40, MM.VRes*8/10, "Import", LB, 2, 1, RGB(White)
  'Text MM.HRes/40, MM.VRes*9/10, "Line9", LB, 2, 1, RGB(Magenta)
  'Text MM.HRes/40, MM.VRes*10/10,"Line10", LB, 2, 1, RGB(Green)
  
  Text MM.HRes*25/40, MM.VRes*1/10, Str$(Volts(1),4,1), RB, 2, 1, RGB(Green)
  Text MM.HRes*25/40, MM.VRes*2/10, Str$(Amps(1),3,2), RB, 2, 1, RGB(Cyan)
  Text MM.HRes*25/40, MM.VRes*3/10, Str$(Watts(1)/k,3,2), RB, 2, 1, RGB(Red)
  Text MM.HRes*25/40, MM.VRes*4/10, Str$(VAs(1)/k ,3,2), RB, 2, 1, RGB(Blue)
  Text MM.HRes*25/40, MM.VRes*5/10, Str$(VAsR(1)/k,3,2), RB, 2, 1, RGB(Cyan)
  Text MM.HRes*25/40, MM.VRes*6/10, Str$(PF(1),3,2), RB, 2, 1, RGB(Magenta)
  Text MM.HRes*25/40, MM.VRes*7/10, Str$(Watts(4),4,1), RB, 2, 1, RGB(Yellow)
  Text MM.HRes*25/40, MM.VRes*8/10, Str$(TotImp(1),4,1), RB, 2, 1, RGB(White)
  '  Text MM.HRes/2, MM.VRes*9/10, "Line9", CB, 2, 1, RGB(White)
  '  Text MM.HRes/2, MM.VRes*10/10, SecsTime(PumpRunTime), CB, 2, 1, RGB(Green)
  
  Text MM.HRes*39/40, MM.VRes*1/10, Str$(Volts(2),4,1), RB, 2, 1, RGB(Green)
  Text MM.HRes*39/40, MM.VRes*2/10, Str$(Amps(2),3,2), RB, 2, 1, RGB(Cyan)
  Text MM.HRes*39/40, MM.VRes*3/10, Str$(Watts(2)/k,3,2), RB, 2, 1, RGB(Red)
  Text MM.HRes*39/40, MM.VRes*4/10, Str$(VAs(2)/k,3,2), RB, 2, 1, RGB(Blue)
  Text MM.HRes*39/40, MM.VRes*5/10, Str$(VAsR(2)/k,3,2), RB, 2, 1, RGB(Cyan)
  Text MM.HRes*39/40, MM.VRes*6/10, Str$(PF(2),3,2), RB, 2, 1, RGB(Magenta)
  Text MM.HRes*39/40, MM.VRes*7/10, Str$(Watts(3),4,1), RB, 2, 1, RGB(Yellow)
  Text MM.HRes*39/40, MM.VRes*8/10, Str$(TotImp(2),4,1), RB, 2, 1, RGB(White)
  '  Text MM.HRes/2, MM.VRes*9/10, Time$, CB, 2, 1, RGB(White)
  '  Text MM.HRes/2, MM.VRes*10/10, SecsTime(PumpRunTime), CB, 2, 1, RGB(Green)
  
End Sub
  
Sub UpdateConsole
  Local integer n,p
  ''Print Esc;"[2J";Esc;"[f"
  Print Esc+"[f";
  Print "               Utility   Solar In  Solar Out"
  Print "============================================"
  Print "Volts    : ";Str$(Volts(1),8,2);Str$(Volts(2),8,2);Str$(Volts(3),8,2)
  Print "Amps     : ";Str$(Amps(1),8,2);Str$(Amps(2),8,2);Str$(Amps(3),8,2)
  Print "Watts    : ";Str$(Watts(1),8,2);Str$(Watts(2),8,2);Str$(Watts(3),8,2);" $";Str$(Watts(1)*.2847*0.0011,3,2)
  Print "VA       : ";Str$(VAs(1),8,2);Str$(VAs(2),8,2);Str$(VAs(3),8,2)
  Print "VAr      : ";Str$(VAsR(1),8,2);Str$(VAsR(2),8,2);Str$(VAsR(3),8,2)
  Print "P/Factor : ";Str$(PF(1),8,2);Str$(PF(2),8,2);Str$(PF(3),8,2)
  Print "Import   : ";Str$(TotImp(1),8,2);Str$(TotImp(2),8,2);Str$(TotImp(3),8,2)
  Print "Export   : ";Str$(TotExp(1),8,2);Str$(TotExp(2),8,2);Str$(TotExp(3),8,2)
  Print
  Print "Solar Watts";Str$(Watts(2),8,2);Str$(Watts(4),8,2);Str$(Watts(3),8,2)
  Print "Solar VA : ";"           ";Str$(VAs(4),8,2)
  
  Print Esc+"[K"
  Print "Time to Process Coms:= "; TimerRc
  Print "Request Type-"; ReqType; " Req Number-"; Str$(ReqNum,4,0)
'  Print "Request Type-"; ReqType, " Address-"; Addr%; " Req Number-"; Str$(ReqNum,4,0)
'  Print
'  Print "Request"
'  
'  For p=1 To Len(ReqStr)
'    Print Hex$(Asc(Mid$(ReqStr,p,1)),2);" ";
'  Next p
'  
'  Print
'  Print "Response"
'  
'  For n=1 To Len(DataStr)
'    Print Hex$(Asc(Mid$(DataStr,n,1)),2);" ";
'  Next n
'  
  Print Esc+"[K"
  Print Esc+"[J";
  
  
End Sub
  
  ' Font: Hom_16x24_LE
  ' Includes all ASCII characters
DefineFont #2
  5F201810 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 80010000 80018001
  80018001 80018001 00018001 00010001 00000000 80010000 00008001 00000000
  00000000 00000000 700E0000 700E700E 2004700E 20042004 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 20010000 20012001
  20012001 F80F2001 40024002 F01F4002 40024002 40024002 40024002 00000000
  00000000 00000000 80008000 E8018000 08041802 00040004 E0010002 08001000
  08080800 E00B100C 80008000 80008000 00000000 00000000 00070000 40108008
  40104010 1C078008 0007E000 88007038 04010401 88000401 00007000 00000000
  00000000 00000000 00000000 00000000 C004A003 00040004 00060002 20113009
  4010C010 A0086010 00001807 00000000 00000000 00000000 70000000 E0007000
  8001C000 00000001 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 10000000 20002000 40004000 80004000 80008000 80008000
  80008000 40004000 20004000 10002000 00000000 00000000 00080000 00040004
  00020002 00010002 00010001 00010001 00010001 00020002 00040002 00080004
  00000000 00000000 80000000 80008000 F007980C 6003C001 180C3006 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  80008000 80008000 FC1F8000 80008000 80008000 00008000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 00038003 00040006 00000000 00000000 00000000 00000000
  00000000 00000000 FC1F0000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 08000000 10000800
  20001000 40002000 80004000 00018000 00020001 00040002 00080004 00000008
  00000000 00000000 00000000 3006C001 08081004 08080808 08080808 08080808
  08080808 30061004 0000C001 00000000 00000000 00000000 00000000 800E8001
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 200CC003 10101010 10001000 40002000 00018000
  00040002 08100008 0000F81F 00000000 00000000 00000000 00000000 3008C007
  10001000 20001000 3000C003 08000800 08000800 300C0810 0000C003 00000000
  00000000 00000000 00000000 A0006000 20012001 20042002 20082004 20102008
  2000F81F 20002000 0000F801 00000000 00000000 00000000 00000000 0008F00F
  00080008 C00B0008 1000300C 08000800 08000800 30181000 0000C007 00000000
  00000000 00000000 00000000 0003F000 00040006 E0090008 080C100A 08080808
  08080808 10060804 0000E001 00000000 00000000 00000000 00000000 1010F01F
  20002010 40002000 40004000 80004000 80008000 00010001 00000001 00000000
  00000000 00000000 00000000 2004C003 10081008 10081008 E0072004 08101008
  08100810 300C1008 0000C003 00000000 00000000 00000000 00000000 3006C001
  0808180C 08080808 28061804 0800C801 10000800 60001000 0000800F 00000000
  00000000 00000000 00000000 00000000 00000000 C001C001 0000C001 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 C001C001 00038003 00040006
  00000000 00000000 00000000 00000000 60001800 00068001 00300018 00060018
  60008001 00001800 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 0000FC3F FC3F0000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00060018 60008001 0C001800 60001800
  00068001 00000018 00000000 00000000 00000000 00000000 00000000 C0070000
  10082008 10001000 20001000 0001C000 00000001 80010000 00008001 00000000
  00000000 00000000 C0030000 1008200C 10101010 90107010 10111011 10111011
  78109010 00100010 300C0008 0000E003 00000000 00000000 00000000 C00F0000
  20024001 20022002 10041004 F80F1004 08080808 04100410 00001E3C 00000000
  00000000 00000000 00000000 F03F0000 04080808 04080408 F00F0808 04080808
  04080408 08080408 0000F03F 00000000 00000000 00000000 00000000 E4010000
  0C0C1406 00100408 00100010 00100010 04080010 18060C0C 0000E001 00000000
  00000000 00000000 00000000 E03F0000 08101810 04100410 04100410 04100410
  04100410 18100810 0000E03F 00000000 00000000 00000000 00000000 F83F0000
  08080808 80080808 800F8008 80088008 04080408 04080408 0000FC3F 00000000
  00000000 00000000 00000000 FC1F0000 04040404 40040404 C0074004 40044004
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 C8030000
  1818280C 00200810 00200020 FC200020 08100820 100C0818 0000E003 00000000
  00000000 00000000 00000000 3E3E0000 08080808 08080808 F80F0808 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 F80F0000
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 FE030000 10001000 10001000 10001000 10101000
  10101010 60082010 00008007 00000000 00000000 00000000 00000000 3C3E0000
  20081008 80084008 000B0009 4008800C 10082008 08081008 00001E3E 00000000
  00000000 00000000 00000000 803F0000 00040004 00040004 00040004 00040004
  04040404 04040404 0000FC3F 00000000 00000000 00000000 00000000 0E380000
  0C180C18 14141414 24122412 C4114411 04100410 04100410 00001E3C 00000000
  00000000 00000000 00000000 7E780000 08140818 08120812 08110811 88108810
  48104810 18102810 0000187E 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 0000E003 00000000
  00000000 00000000 00000000 F01F0000 04040804 04040404 08040404 0004F007
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 8C01E003 0000F006
  00000000 00000000 00000000 E03F0000 08081008 08080808 10080808 4008E00F
  10082008 08081008 00000E3E 00000000 00000000 00000000 00000000 C8030000
  1810280C 00100810 C003000C 08003000 08100800 10140818 0000E013 00000000
  00000000 00000000 00000000 FC1F0000 84108410 84108410 80008000 80008000
  80008000 80008000 0000F007 00000000 00000000 00000000 00000000 7C3E0000
  08100810 08100810 08100810 08100810 08100810 10080810 0000E007 00000000
  00000000 00000000 00000000 3E3E0000 04100410 08080808 10041004 20021004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 3E3E0000
  04100410 84108410 44114411 280A4809 280A280A 180C180C 0000180C 00000000
  00000000 00000000 00000000 3E3E0000 10040808 20021004 80004001 20024001
  10042002 08080808 00003E3E 00000000 00000000 00000000 00000000 1E3C0000
  10040808 20021004 40012002 80008000 80008000 80008000 0000F007 00000000
  00000000 00000000 00000000 F81F0000 10100810 40102010 80004000 00020001
  08040802 08100808 0000F81F 00000000 00000000 00000000 E0000000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 E0008000
  00000000 00000000 00080000 00040008 00020004 00010002 80000001 40008000
  20004000 10002000 08001000 00000800 00000000 00000000 80030000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 80038000
  00000000 00000000 80000000 2002C001 08081004 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  FF7F0000 00000000 80030000 C0018003 6000C000 00002000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 2008C007 10001000 3008D007 10101010 30081010 0000DC07 00000000
  00000000 00000000 00000000 00080038 00080008 0C0AF009 0208040C 02080208
  02080208 0C0A040C 0000F039 00000000 00000000 00000000 00000000 00000000
  00000000 180CE803 08100808 00100010 00100010 180C0C08 0000E003 00000000
  00000000 00000000 00000000 08003800 08000800 2818C807 08201810 08200820
  08200820 28181810 0000CE07 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 FC1F0410 00100010 0C0C0008 0000F003 00000000
  00000000 00000000 00000000 8401F800 00010001 0001F80F 00010001 00010001
  00010001 00010001 0000F80F 00000000 00000000 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 10000800
  C00F3000 00000000 00000000 00080038 00080008 100AE009 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 80000000 80008000
  00000000 80008007 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 20000000 20002000 00000000 1000F00F 10001000 10001000
  10001000 10001000 10001000 20001000 800F6000 00000000 00000000 0004001C
  00040004 20047804 80044004 00070005 40048004 10042004 00003C1C 00000000
  00000000 00000000 00000000 8000800F 80008000 80008000 80008000 80008000
  80008000 80008000 0000FC1F 00000000 00000000 00000000 00000000 00000000
  00000000 C4183877 84108410 84108410 84108410 84108410 0000C67C 00000000
  00000000 00000000 00000000 00000000 00000000 100AE039 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 04100410 04100410 180C0808 0000E003 00000000
  00000000 00000000 00000000 00000000 00000000 0C0AF039 0208040C 02080208
  02080208 0C0A040C 0008F009 00080008 003F0008 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 08000800
  7E000800 00000000 00000000 00000000 00000000 C402380E 00020003 00020002
  00020002 00020002 0000F01F 00000000 00000000 00000000 00000000 00000000
  00000000 1804E803 00040804 70008003 08000800 100C0808 0000E00B 00000000
  00000000 00000000 00000000 00040004 00040004 0004F01F 00040004 00040004
  00040004 18020004 0000E001 00000000 00000000 00000000 00000000 00000000
  00000000 08083838 08080808 08080808 08080808 28041808 0000CC03 00000000
  00000000 00000000 00000000 00000000 00000000 08083E3E 10040808 10041004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 00000000
  00000000 04101E3C 84100410 48098808 48094809 30065005 00003006 00000000
  00000000 00000000 00000000 00000000 00000000 08083C1E 20021004 80004001
  20024001 08081004 00003C1E 00000000 00000000 00000000 00000000 00000000
  00000000 08103C3C 10080810 20081008 40042004 80024002 00018001 00020001
  803F0002 00000000 00000000 00000000 00000000 0808F80F 20001008 80004000
  00020001 08080804 0000F80F 00000000 00000000 00000000 60000000 80008000
  80008000 80008000 80008000 80000003 80008000 80008000 80008000 60008000
  00000000 00000000 00000000 80000000 80008000 80008000 80008000 80008000
  80008000 80008000 80008000 80008000 00000000 00000000 00030000 80008000
  80008000 80008000 80008000 80006000 80008000 80008000 80008000 00038000
  00000000 00000000 00000000 00000000 00000000 00000000 98190C0F 0000F030
  00000000 00000000 00000000 00000000 00000000
End DefineFont
